/* 
Copyright (c) 2010, NHIN Direct Project
All rights reserved.

Authors:
   Greg Meyer      gm2552@cerner.com
 
Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer 
in the documentation and/or other materials provided with the distribution.  Neither the name of the The NHIN Direct Project (nhindirect.org). 
nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
THE POSSIBILITY OF SUCH DAMAGE.
*/

package org.nhindirect.policy;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * Serializes a {@link PolicyExpression} to an external medium and vice versa.  The format of the serialized object is specific to the concrete implementation
 * of this interface.
 * <br>
 * Serialized versions of a {@link PolicyExpression} are useful to store the intermediate state generated by a {@link PolicyLexiconParser}.
 * @author Greg Meyer
 * @since 1.0
 */
public interface PolicyExpressionSerializer 
{
	/**
	 * Deserializes the contents of input stream to a PolicyExpression.
	 * @param stream The serialized content in an input stream.
	 * @return The {@link PolicyExpression} that has been serialized.
	 * @throws PolicyParseException Thrown if the input stream cannot be deserialized successfully into a {@link PolicyExpression} object.
	 */
	public PolicyExpression deserialize(InputStream stream) throws PolicyParseException; 
	
	/**
	 * Serialized a {@link PolicyExpression} to an output stream.
	 * @param expression The expression to serialize.
	 * @param stream The output stream to write the serialized expression to.
	 * @throws PolicyParseException Thrown if the {@link PolicyExpression} object cannot be successfully serialized to the output stream.
	 */
	public void serialize(PolicyExpression expression, OutputStream stream) throws PolicyParseException; 
}
